package zio.aws.lexruntime.model
import scala.jdk.CollectionConverters._
sealed trait DialogActionType {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType
}
object DialogActionType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.DialogActionType
  ): zio.aws.lexruntime.model.DialogActionType = value match {
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.CLOSE =>
      val r = Close
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.DELEGATE =>
      val r = Delegate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object ElicitIntent extends zio.aws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_INTENT
  }
  case object ConfirmIntent extends zio.aws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.CONFIRM_INTENT
  }
  case object ElicitSlot extends zio.aws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_SLOT
  }
  case object Close extends zio.aws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.CLOSE
  }
  case object Delegate extends zio.aws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.DELEGATE
  }
}
