package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSessionResponse(
    recentIntentSummaryView: Option[
      Iterable[zio.aws.lexruntime.model.IntentSummary]
    ] = None,
    sessionAttributes: Option[Map[String, String]] = None,
    sessionId: Option[String] = None,
    dialogAction: Option[zio.aws.lexruntime.model.DialogAction] = None,
    activeContexts: Option[Iterable[zio.aws.lexruntime.model.ActiveContext]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.GetSessionResponse = {
    import GetSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
      .builder()
      .optionallyWith(
        recentIntentSummaryView.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recentIntentSummaryView)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(dialogAction.map(value => value.buildAwsValue()))(
        _.dialogAction
      )
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.GetSessionResponse.ReadOnly =
    zio.aws.lexruntime.model.GetSessionResponse.wrap(buildAwsValue())
}
object GetSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.GetSessionResponse =
      zio.aws.lexruntime.model.GetSessionResponse(
        recentIntentSummaryView.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sessionAttributes.map(value => value),
        sessionId.map(value => value),
        dialogAction.map(value => value.asEditable),
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recentIntentSummaryView
        : Option[List[zio.aws.lexruntime.model.IntentSummary.ReadOnly]]
    def sessionAttributes: Option[Map[String, String]]
    def sessionId: Option[String]
    def dialogAction: Option[zio.aws.lexruntime.model.DialogAction.ReadOnly]
    def activeContexts
        : Option[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]]
    def getRecentIntentSummaryView: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.IntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recentIntentSummaryView",
      recentIntentSummaryView
    )
    def getSessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getDialogAction
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.DialogAction.ReadOnly] =
      AwsError.unwrapOptionField("dialogAction", dialogAction)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
  ) extends zio.aws.lexruntime.model.GetSessionResponse.ReadOnly {
    override val recentIntentSummaryView
        : Option[List[zio.aws.lexruntime.model.IntentSummary.ReadOnly]] = scala
      .Option(impl.recentIntentSummaryView())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntime.model.IntentSummary.wrap(item)
        }.toList
      )
    override val sessionAttributes: Option[Map[String, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val sessionId: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
    override val dialogAction
        : Option[zio.aws.lexruntime.model.DialogAction.ReadOnly] = scala
      .Option(impl.dialogAction())
      .map(value => zio.aws.lexruntime.model.DialogAction.wrap(value))
    override val activeContexts
        : Option[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]] = scala
      .Option(impl.activeContexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntime.model.ActiveContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
  ): zio.aws.lexruntime.model.GetSessionResponse.ReadOnly = new Wrapper(impl)
}
