package zio.aws.lexruntime
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.lexruntime.{
  LexRuntimeAsyncClientBuilder,
  LexRuntimeAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, ZManaged, IO, ZIO, ZLayer}
import zio.aws.lexruntime.model.{
  PostContentRequest,
  DeleteSessionRequest,
  GetSessionRequest,
  PutSessionRequest,
  PostTextRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.lexruntime.model.{
  PostTextResponse,
  DeleteSessionResponse,
  GetSessionResponse,
  PostContentResponse,
  PutSessionResponse
}
import scala.jdk.CollectionConverters._
trait LexRuntime extends AspectSupport[LexRuntime] {
  val api: LexRuntimeAsyncClient
  def deleteSession(request: DeleteSessionRequest): IO[AwsError, ReadOnly]
  def postText(
      request: PostTextRequest
  ): IO[AwsError, zio.aws.lexruntime.model.PostTextResponse.ReadOnly]
  def postContent(
      request: PostContentRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.lexruntime.model.PostContentResponse.ReadOnly,
    Byte
  ]]
  def putSession(
      request: PutSessionRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.lexruntime.model.PutSessionResponse.ReadOnly,
    Byte
  ]]
  def getSession(
      request: GetSessionRequest
  ): IO[AwsError, zio.aws.lexruntime.model.GetSessionResponse.ReadOnly]
}
object LexRuntime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, LexRuntime] = customized(
    identity
  )
  def customized(
      customization: LexRuntimeAsyncClientBuilder => LexRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LexRuntime] = managed(
    customization
  ).toLayer
  def managed(
      customization: LexRuntimeAsyncClientBuilder => LexRuntimeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, LexRuntime] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = LexRuntimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LexRuntimeAsyncClient, LexRuntimeAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[LexRuntimeAsyncClient, LexRuntimeAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new LexRuntimeImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class LexRuntimeImpl[R](
      override val api: LexRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LexRuntime
      with AwsServiceBase[R] {
    override val serviceName: String = "LexRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LexRuntimeImpl[R1] = new LexRuntimeImpl(api, newAspect, r)
    def deleteSession(request: DeleteSessionRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest,
        DeleteSessionResponse
      ]("deleteSession", api.deleteSession)(request.buildAwsValue())
        .map(zio.aws.lexruntime.model.DeleteSessionResponse.wrap)
        .provideEnvironment(r)
    def postText(
        request: PostTextRequest
    ): IO[AwsError, zio.aws.lexruntime.model.PostTextResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexruntime.model.PostTextRequest,
        PostTextResponse
      ]("postText", api.postText)(request.buildAwsValue())
        .map(zio.aws.lexruntime.model.PostTextResponse.wrap)
        .provideEnvironment(r)
    def postContent(
        request: PostContentRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.lexruntime.model.PostContentResponse.ReadOnly,
      Byte
    ]] = asyncRequestInputOutputStream[
      software.amazon.awssdk.services.lexruntime.model.PostContentRequest,
      PostContentResponse
    ](
      "postContent",
      api.postContent[Task[StreamingOutputResult[R, PostContentResponse, Byte]]]
    )(request.buildAwsValue(), body)
      .map(
        _.mapResponse(zio.aws.lexruntime.model.PostContentResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def putSession(
        request: PutSessionRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.lexruntime.model.PutSessionResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.lexruntime.model.PutSessionRequest,
      PutSessionResponse
    ](
      "putSession",
      api.putSession[Task[StreamingOutputResult[R, PutSessionResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.lexruntime.model.PutSessionResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getSession(
        request: GetSessionRequest
    ): IO[AwsError, zio.aws.lexruntime.model.GetSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexruntime.model.GetSessionRequest,
        GetSessionResponse
      ]("getSession", api.getSession)(request.buildAwsValue())
        .map(zio.aws.lexruntime.model.GetSessionResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteSession(
      request: DeleteSessionRequest
  ): ZIO[zio.aws.lexruntime.LexRuntime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteSession(request))
  def postText(request: PostTextRequest): ZIO[
    zio.aws.lexruntime.LexRuntime,
    AwsError,
    zio.aws.lexruntime.model.PostTextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.postText(request))
  def postContent(
      request: PostContentRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[zio.aws.lexruntime.LexRuntime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.lexruntime.model.PostContentResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.postContent(request, body))
  def putSession(
      request: PutSessionRequest
  ): ZIO[zio.aws.lexruntime.LexRuntime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.lexruntime.model.PutSessionResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.putSession(request))
  def getSession(request: GetSessionRequest): ZIO[
    zio.aws.lexruntime.LexRuntime,
    AwsError,
    zio.aws.lexruntime.model.GetSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSession(request))
}
