package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestExecutionTarget(
    botAliasTarget: Optional[
      zio.aws.lexmodelsv2.model.BotAliasTestExecutionTarget
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionTarget = {
    import TestExecutionTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionTarget
      .builder()
      .optionallyWith(botAliasTarget.map(value => value.buildAwsValue()))(
        _.botAliasTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly =
    zio.aws.lexmodelsv2.model.TestExecutionTarget.wrap(buildAwsValue())
}
object TestExecutionTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestExecutionTarget =
      zio.aws.lexmodelsv2.model
        .TestExecutionTarget(botAliasTarget.map(value => value.asEditable))
    def botAliasTarget: Optional[
      zio.aws.lexmodelsv2.model.BotAliasTestExecutionTarget.ReadOnly
    ]
    def getBotAliasTarget: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotAliasTestExecutionTarget.ReadOnly
    ] = AwsError.unwrapOptionField("botAliasTarget", botAliasTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionTarget
  ) extends zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly {
    override val botAliasTarget: Optional[
      zio.aws.lexmodelsv2.model.BotAliasTestExecutionTarget.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasTarget())
      .map(value =>
        zio.aws.lexmodelsv2.model.BotAliasTestExecutionTarget.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionTarget
  ): zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly = new Wrapper(impl)
}
