package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsUtteranceAttributeResult(
    lastUsedIntent: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult = {
    import AnalyticsUtteranceAttributeResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult
      .builder()
      .optionallyWith(
        lastUsedIntent.map(value => Name.unwrap(value): java.lang.String)
      )(_.lastUsedIntent)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult
      .wrap(buildAwsValue())
}
object AnalyticsUtteranceAttributeResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult =
      zio.aws.lexmodelsv2.model
        .AnalyticsUtteranceAttributeResult(lastUsedIntent.map(value => value))
    def lastUsedIntent: Optional[Name]
    def getLastUsedIntent: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("lastUsedIntent", lastUsedIntent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.ReadOnly {
    override val lastUsedIntent: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUsedIntent())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult
  ): zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.ReadOnly =
    new Wrapper(impl)
}
