package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait ConversationEndState {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState
}
object ConversationEndState {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState
  ): zio.aws.lexmodelsv2.model.ConversationEndState = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.FAILURE =>
      val r = Failure
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.DROPPED =>
      val r = Dropped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ConversationEndState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState =
      software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.UNKNOWN_TO_SDK_VERSION
  }
  case object Success extends zio.aws.lexmodelsv2.model.ConversationEndState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState =
      software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.SUCCESS
  }
  case object Failure extends zio.aws.lexmodelsv2.model.ConversationEndState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState =
      software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.FAILURE
  }
  case object Dropped extends zio.aws.lexmodelsv2.model.ConversationEndState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState =
      software.amazon.awssdk.services.lexmodelsv2.model.ConversationEndState.DROPPED
  }
}
