package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.TestResultSlotName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SlotResolutionTestResultItem(
    slotName: TestResultSlotName,
    resultCounts: zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem = {
    import SlotResolutionTestResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem
      .builder()
      .slotName(TestResultSlotName.unwrap(slotName): java.lang.String)
      .resultCounts(resultCounts.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.wrap(buildAwsValue())
}
object SlotResolutionTestResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem =
      zio.aws.lexmodelsv2.model
        .SlotResolutionTestResultItem(slotName, resultCounts.asEditable)
    def slotName: TestResultSlotName
    def resultCounts
        : zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts.ReadOnly
    def getSlotName: ZIO[Any, Nothing, TestResultSlotName] =
      ZIO.succeed(slotName)
    def getResultCounts: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts.ReadOnly
    ] = ZIO.succeed(resultCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem
  ) extends zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.ReadOnly {
    override val slotName: TestResultSlotName =
      zio.aws.lexmodelsv2.model.primitives.TestResultSlotName(impl.slotName())
    override val resultCounts
        : zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts.ReadOnly =
      zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts
        .wrap(impl.resultCounts())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem
  ): zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.ReadOnly =
    new Wrapper(impl)
}
