package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.RuntimeHintPhrase
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RuntimeHintValue(phrase: RuntimeHintPhrase) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue = {
    import RuntimeHintValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue
      .builder()
      .phrase(RuntimeHintPhrase.unwrap(phrase): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.RuntimeHintValue.ReadOnly =
    zio.aws.lexmodelsv2.model.RuntimeHintValue.wrap(buildAwsValue())
}
object RuntimeHintValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.RuntimeHintValue =
      zio.aws.lexmodelsv2.model.RuntimeHintValue(phrase)
    def phrase: RuntimeHintPhrase
    def getPhrase: ZIO[Any, Nothing, RuntimeHintPhrase] = ZIO.succeed(phrase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue
  ) extends zio.aws.lexmodelsv2.model.RuntimeHintValue.ReadOnly {
    override val phrase: RuntimeHintPhrase =
      zio.aws.lexmodelsv2.model.primitives.RuntimeHintPhrase(impl.phrase())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue
  ): zio.aws.lexmodelsv2.model.RuntimeHintValue.ReadOnly = new Wrapper(impl)
}
