package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuntimeHintDetails(
    runtimeHintValues: Optional[
      Iterable[zio.aws.lexmodelsv2.model.RuntimeHintValue]
    ] = Optional.Absent,
    subSlotHints: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.RuntimeHintDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintDetails = {
    import RuntimeHintDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintDetails
      .builder()
      .optionallyWith(
        runtimeHintValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runtimeHintValues)
      .optionallyWith(
        subSlotHints.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.subSlotHints)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.RuntimeHintDetails.ReadOnly =
    zio.aws.lexmodelsv2.model.RuntimeHintDetails.wrap(buildAwsValue())
}
object RuntimeHintDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.RuntimeHintDetails =
      zio.aws.lexmodelsv2.model.RuntimeHintDetails(
        runtimeHintValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subSlotHints.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def runtimeHintValues
        : Optional[List[zio.aws.lexmodelsv2.model.RuntimeHintValue.ReadOnly]]
    def subSlotHints: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.RuntimeHintDetails.ReadOnly]
    ]
    def getRuntimeHintValues: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.RuntimeHintValue.ReadOnly
    ]] = AwsError.unwrapOptionField("runtimeHintValues", runtimeHintValues)
    def getSubSlotHints: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.lexmodelsv2.model.RuntimeHintDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("subSlotHints", subSlotHints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintDetails
  ) extends zio.aws.lexmodelsv2.model.RuntimeHintDetails.ReadOnly {
    override val runtimeHintValues
        : Optional[List[zio.aws.lexmodelsv2.model.RuntimeHintValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeHintValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.RuntimeHintValue.wrap(item)
          }.toList
        )
    override val subSlotHints: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.RuntimeHintDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subSlotHints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.Name(
              key
            ) -> zio.aws.lexmodelsv2.model.RuntimeHintDetails.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintDetails
  ): zio.aws.lexmodelsv2.model.RuntimeHintDetails.ReadOnly = new Wrapper(impl)
}
