package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTestExecutionRequest(testExecutionId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest = {
    import DescribeTestExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest
      .builder()
      .testExecutionId(Id.unwrap(testExecutionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeTestExecutionRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeTestExecutionRequest.wrap(buildAwsValue())
}
object DescribeTestExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeTestExecutionRequest =
      zio.aws.lexmodelsv2.model.DescribeTestExecutionRequest(testExecutionId)
    def testExecutionId: Id
    def getTestExecutionId: ZIO[Any, Nothing, Id] = ZIO.succeed(testExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeTestExecutionRequest.ReadOnly {
    override val testExecutionId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest
  ): zio.aws.lexmodelsv2.model.DescribeTestExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
