package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait AnalyticsInterval {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval
}
object AnalyticsInterval {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval
  ): zio.aws.lexmodelsv2.model.AnalyticsInterval = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval.ONE_HOUR =>
      val r = OneHour
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval.ONE_DAY =>
      val r = OneDay
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.AnalyticsInterval {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval.UNKNOWN_TO_SDK_VERSION
  }
  case object OneHour extends zio.aws.lexmodelsv2.model.AnalyticsInterval {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval.ONE_HOUR
  }
  case object OneDay extends zio.aws.lexmodelsv2.model.AnalyticsInterval {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsInterval.ONE_DAY
  }
}
