package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsIntentResult(
    binKeys: Optional[Iterable[zio.aws.lexmodelsv2.model.AnalyticsBinKey]] =
      Optional.Absent,
    groupByKeys: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey]
    ] = Optional.Absent,
    metricsResults: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentResult = {
    import AnalyticsIntentResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentResult
      .builder()
      .optionallyWith(
        binKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.binKeys)
      .optionallyWith(
        groupByKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupByKeys)
      .optionallyWith(
        metricsResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricsResults)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsIntentResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentResult.wrap(buildAwsValue())
}
object AnalyticsIntentResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentResult =
      zio.aws.lexmodelsv2.model.AnalyticsIntentResult(
        binKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupByKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricsResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]]
    def groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.ReadOnly]
    ]
    def metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.ReadOnly]
    ]
    def getBinKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly
    ]] = AwsError.unwrapOptionField("binKeys", binKeys)
    def getGroupByKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.ReadOnly
    ]] = AwsError.unwrapOptionField("groupByKeys", groupByKeys)
    def getMetricsResults: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricsResults", metricsResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentResult.ReadOnly {
    override val binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.AnalyticsBinKey.wrap(item)
          }.toList
        )
    override val groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupByKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.wrap(item)
        }.toList
      )
    override val metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricsResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentResult
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentResult.ReadOnly = new Wrapper(
    impl
  )
}
