package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait UtteranceContentType {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType
}
object UtteranceContentType {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType
  ): zio.aws.lexmodelsv2.model.UtteranceContentType = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.PLAIN_TEXT =>
      val r = PlainText
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.CUSTOM_PAYLOAD =>
      val r = CustomPayload
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.SSML =>
      val r = SSML
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.IMAGE_RESPONSE_CARD =>
      val r = ImageResponseCard
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.UtteranceContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType =
      software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object PlainText extends zio.aws.lexmodelsv2.model.UtteranceContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType =
      software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.PLAIN_TEXT
  }
  case object CustomPayload
      extends zio.aws.lexmodelsv2.model.UtteranceContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType =
      software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.CUSTOM_PAYLOAD
  }
  case object SSML extends zio.aws.lexmodelsv2.model.UtteranceContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType =
      software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.SSML
  }
  case object ImageResponseCard
      extends zio.aws.lexmodelsv2.model.UtteranceContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType =
      software.amazon.awssdk.services.lexmodelsv2.model.UtteranceContentType.IMAGE_RESPONSE_CARD
  }
}
