package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait TestExecutionStatus {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus
}
object TestExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus
  ): zio.aws.lexmodelsv2.model.TestExecutionStatus = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.WAITING =>
      val r = Waiting
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.PENDING
  }
  case object Waiting extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.WAITING
  }
  case object InProgress extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.COMPLETED
  }
  case object Failed extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.FAILED
  }
  case object Stopping extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.STOPPING
  }
  case object Stopped extends zio.aws.lexmodelsv2.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionStatus.STOPPED
  }
}
