package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTestExecutionResultItemsResponse(
    testExecutionResults: Optional[
      zio.aws.lexmodelsv2.model.TestExecutionResultItems
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse = {
    import ListTestExecutionResultItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse
      .builder()
      .optionallyWith(testExecutionResults.map(value => value.buildAwsValue()))(
        _.testExecutionResults
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsResponse
      .wrap(buildAwsValue())
}
object ListTestExecutionResultItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsResponse =
      zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsResponse(
        testExecutionResults.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def testExecutionResults
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionResultItems.ReadOnly]
    def nextToken: Optional[NextToken]
    def getTestExecutionResults: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestExecutionResultItems.ReadOnly
    ] = AwsError.unwrapOptionField("testExecutionResults", testExecutionResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse
  ) extends zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsResponse.ReadOnly {
    override val testExecutionResults: Optional[
      zio.aws.lexmodelsv2.model.TestExecutionResultItems.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.testExecutionResults())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestExecutionResultItems.wrap(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse
  ): zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsResponse.ReadOnly =
    new Wrapper(impl)
}
