package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ConversationLogsDataSourceFilterBy(
    startTime: Timestamp,
    endTime: Timestamp,
    inputMode: zio.aws.lexmodelsv2.model.ConversationLogsInputModeFilter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSourceFilterBy = {
    import ConversationLogsDataSourceFilterBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSourceFilterBy
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .inputMode(inputMode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy.ReadOnly =
    zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy
      .wrap(buildAwsValue())
}
object ConversationLogsDataSourceFilterBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSourceFilterBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy =
      zio.aws.lexmodelsv2.model
        .ConversationLogsDataSourceFilterBy(startTime, endTime, inputMode)
    def startTime: Timestamp
    def endTime: Timestamp
    def inputMode: zio.aws.lexmodelsv2.model.ConversationLogsInputModeFilter
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getInputMode: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ConversationLogsInputModeFilter
    ] = ZIO.succeed(inputMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSourceFilterBy
  ) extends zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.endTime())
    override val inputMode
        : zio.aws.lexmodelsv2.model.ConversationLogsInputModeFilter =
      zio.aws.lexmodelsv2.model.ConversationLogsInputModeFilter
        .wrap(impl.inputMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSourceFilterBy
  ): zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy.ReadOnly =
    new Wrapper(impl)
}
