package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConversationLevelIntentClassificationResultItem(
    intentName: Name,
    matchResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem = {
    import ConversationLevelIntentClassificationResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem
      .builder()
      .intentName(Name.unwrap(intentName): java.lang.String)
      .matchResult(matchResult.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem
      .wrap(buildAwsValue())
}
object ConversationLevelIntentClassificationResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem =
      zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem(
        intentName,
        matchResult
      )
    def intentName: Name
    def matchResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus
    def getIntentName: ZIO[Any, Nothing, Name] = ZIO.succeed(intentName)
    def getMatchResult
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      ZIO.succeed(matchResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem
  ) extends zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.ReadOnly {
    override val intentName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.intentName())
    override val matchResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus =
      zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(impl.matchResult())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem
  ): zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.ReadOnly =
    new Wrapper(impl)
}
