package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsUtteranceResult(
    binKeys: Optional[Iterable[zio.aws.lexmodelsv2.model.AnalyticsBinKey]] =
      Optional.Absent,
    groupByKeys: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey]
    ] = Optional.Absent,
    metricsResults: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult]
    ] = Optional.Absent,
    attributeResults: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult = {
    import AnalyticsUtteranceResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult
      .builder()
      .optionallyWith(
        binKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.binKeys)
      .optionallyWith(
        groupByKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupByKeys)
      .optionallyWith(
        metricsResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricsResults)
      .optionallyWith(
        attributeResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeResults)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsUtteranceResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsUtteranceResult.wrap(buildAwsValue())
}
object AnalyticsUtteranceResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsUtteranceResult =
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceResult(
        binKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupByKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricsResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attributeResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]]
    def groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.ReadOnly]
    ]
    def metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult.ReadOnly]
    ]
    def attributeResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.ReadOnly]
    ]
    def getBinKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly
    ]] = AwsError.unwrapOptionField("binKeys", binKeys)
    def getGroupByKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.ReadOnly
    ]] = AwsError.unwrapOptionField("groupByKeys", groupByKeys)
    def getMetricsResults: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricsResults", metricsResults)
    def getAttributeResults: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeResults", attributeResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsUtteranceResult.ReadOnly {
    override val binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.AnalyticsBinKey.wrap(item)
          }.toList
        )
    override val groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupByKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.wrap(item)
        }.toList
      )
    override val metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricsResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult.wrap(item)
        }.toList
      )
    override val attributeResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult
  ): zio.aws.lexmodelsv2.model.AnalyticsUtteranceResult.ReadOnly = new Wrapper(
    impl
  )
}
