package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait AnalyticsNodeType {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType
}
object AnalyticsNodeType {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType
  ): zio.aws.lexmodelsv2.model.AnalyticsNodeType = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType.INNER =>
      val r = Inner
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType.EXIT =>
      val r = Exit
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.AnalyticsNodeType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType.UNKNOWN_TO_SDK_VERSION
  }
  case object Inner extends zio.aws.lexmodelsv2.model.AnalyticsNodeType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType.INNER
  }
  case object Exit extends zio.aws.lexmodelsv2.model.AnalyticsNodeType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsNodeType.EXIT
  }
}
