package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{BoxedBoolean, PromptMaxRetries}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PromptSpecification(
    messageGroups: Iterable[zio.aws.lexmodelsv2.model.MessageGroup],
    maxRetries: PromptMaxRetries,
    allowInterrupt: Optional[BoxedBoolean] = Optional.Absent,
    messageSelectionStrategy: Optional[
      zio.aws.lexmodelsv2.model.MessageSelectionStrategy
    ] = Optional.Absent,
    promptAttemptsSpecification: Optional[Map[
      zio.aws.lexmodelsv2.model.PromptAttempt,
      zio.aws.lexmodelsv2.model.PromptAttemptSpecification
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification = {
    import PromptSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
      .builder()
      .messageGroups(messageGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .maxRetries(PromptMaxRetries.unwrap(maxRetries): Integer)
      .optionallyWith(allowInterrupt.map(value => value: java.lang.Boolean))(
        _.allowInterrupt
      )
      .optionallyWith(messageSelectionStrategy.map(value => value.unwrap))(
        _.messageSelectionStrategy
      )
      .optionallyWith(
        promptAttemptsSpecification.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.promptAttemptsSpecificationWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.PromptSpecification.wrap(buildAwsValue())
}
object PromptSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.PromptSpecification =
      zio.aws.lexmodelsv2.model.PromptSpecification(
        messageGroups.map { item =>
          item.asEditable
        },
        maxRetries,
        allowInterrupt.map(value => value),
        messageSelectionStrategy.map(value => value),
        promptAttemptsSpecification.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def messageGroups: List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly]
    def maxRetries: PromptMaxRetries
    def allowInterrupt: Optional[BoxedBoolean]
    def messageSelectionStrategy
        : Optional[zio.aws.lexmodelsv2.model.MessageSelectionStrategy]
    def promptAttemptsSpecification: Optional[Map[
      zio.aws.lexmodelsv2.model.PromptAttempt,
      zio.aws.lexmodelsv2.model.PromptAttemptSpecification.ReadOnly
    ]]
    def getMessageGroups: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly
    ]] = ZIO.succeed(messageGroups)
    def getMaxRetries: ZIO[Any, Nothing, PromptMaxRetries] =
      ZIO.succeed(maxRetries)
    def getAllowInterrupt: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("allowInterrupt", allowInterrupt)
    def getMessageSelectionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.MessageSelectionStrategy
    ] = AwsError.unwrapOptionField(
      "messageSelectionStrategy",
      messageSelectionStrategy
    )
    def getPromptAttemptsSpecification: ZIO[Any, AwsError, Map[
      zio.aws.lexmodelsv2.model.PromptAttempt,
      zio.aws.lexmodelsv2.model.PromptAttemptSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "promptAttemptsSpecification",
      promptAttemptsSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
  ) extends zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly {
    override val messageGroups
        : List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly] = impl
      .messageGroups()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.MessageGroup.wrap(item)
      }
      .toList
    override val maxRetries: PromptMaxRetries =
      zio.aws.lexmodelsv2.model.primitives.PromptMaxRetries(impl.maxRetries())
    override val allowInterrupt: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowInterrupt())
      .map(value => value: BoxedBoolean)
    override val messageSelectionStrategy
        : Optional[zio.aws.lexmodelsv2.model.MessageSelectionStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageSelectionStrategy())
        .map(value =>
          zio.aws.lexmodelsv2.model.MessageSelectionStrategy.wrap(value)
        )
    override val promptAttemptsSpecification: Optional[Map[
      zio.aws.lexmodelsv2.model.PromptAttempt,
      zio.aws.lexmodelsv2.model.PromptAttemptSpecification.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.promptAttemptsSpecification())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.PromptAttempt
              .wrap(key) -> zio.aws.lexmodelsv2.model.PromptAttemptSpecification
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
  ): zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly = new Wrapper(impl)
}
