package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTestSetRequest(testSetId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest = {
    import DeleteTestSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest
      .builder()
      .testSetId(Id.unwrap(testSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteTestSetRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteTestSetRequest.wrap(buildAwsValue())
}
object DeleteTestSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteTestSetRequest =
      zio.aws.lexmodelsv2.model.DeleteTestSetRequest(testSetId)
    def testSetId: Id
    def getTestSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(testSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteTestSetRequest.ReadOnly {
    override val testSetId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest
  ): zio.aws.lexmodelsv2.model.DeleteTestSetRequest.ReadOnly = new Wrapper(impl)
}
