package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsMetricValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsUtteranceMetricResult(
    name: Optional[zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName] =
      Optional.Absent,
    statistic: Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic] =
      Optional.Absent,
    value: Optional[AnalyticsMetricValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult = {
    import AnalyticsUtteranceMetricResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => AnalyticsMetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult
      .wrap(buildAwsValue())
}
object AnalyticsUtteranceMetricResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult =
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName]
    def statistic: Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic]
    def value: Optional[AnalyticsMetricValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, AnalyticsMetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult.ReadOnly {
    override val name
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName.wrap(value)
        )
    override val statistic
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic.wrap(value)
        )
    override val value: Optional[AnalyticsMetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsMetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult
  ): zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricResult.ReadOnly =
    new Wrapper(impl)
}
