package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TurnSpecification(
    agentTurn: Optional[zio.aws.lexmodelsv2.model.AgentTurnSpecification] =
      Optional.Absent,
    userTurn: Optional[zio.aws.lexmodelsv2.model.UserTurnSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TurnSpecification = {
    import TurnSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TurnSpecification
      .builder()
      .optionallyWith(agentTurn.map(value => value.buildAwsValue()))(
        _.agentTurn
      )
      .optionallyWith(userTurn.map(value => value.buildAwsValue()))(_.userTurn)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TurnSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.TurnSpecification.wrap(buildAwsValue())
}
object TurnSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TurnSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TurnSpecification =
      zio.aws.lexmodelsv2.model.TurnSpecification(
        agentTurn.map(value => value.asEditable),
        userTurn.map(value => value.asEditable)
      )
    def agentTurn
        : Optional[zio.aws.lexmodelsv2.model.AgentTurnSpecification.ReadOnly]
    def userTurn
        : Optional[zio.aws.lexmodelsv2.model.UserTurnSpecification.ReadOnly]
    def getAgentTurn: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AgentTurnSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("agentTurn", agentTurn)
    def getUserTurn: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UserTurnSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("userTurn", userTurn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TurnSpecification
  ) extends zio.aws.lexmodelsv2.model.TurnSpecification.ReadOnly {
    override val agentTurn
        : Optional[zio.aws.lexmodelsv2.model.AgentTurnSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentTurn())
        .map(value =>
          zio.aws.lexmodelsv2.model.AgentTurnSpecification.wrap(value)
        )
    override val userTurn
        : Optional[zio.aws.lexmodelsv2.model.UserTurnSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userTurn())
        .map(value =>
          zio.aws.lexmodelsv2.model.UserTurnSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TurnSpecification
  ): zio.aws.lexmodelsv2.model.TurnSpecification.ReadOnly = new Wrapper(impl)
}
