package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestSetDiscrepancyErrors(
    intentDiscrepancies: Iterable[
      zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem
    ],
    slotDiscrepancies: Iterable[
      zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyErrors = {
    import TestSetDiscrepancyErrors.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyErrors
      .builder()
      .intentDiscrepancies(intentDiscrepancies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .slotDiscrepancies(slotDiscrepancies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.wrap(buildAwsValue())
}
object TestSetDiscrepancyErrors {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyErrors
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors =
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors(
        intentDiscrepancies.map { item =>
          item.asEditable
        },
        slotDiscrepancies.map { item =>
          item.asEditable
        }
      )
    def intentDiscrepancies
        : List[zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.ReadOnly]
    def slotDiscrepancies
        : List[zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.ReadOnly]
    def getIntentDiscrepancies: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.ReadOnly
    ]] = ZIO.succeed(intentDiscrepancies)
    def getSlotDiscrepancies: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.ReadOnly
    ]] = ZIO.succeed(slotDiscrepancies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyErrors
  ) extends zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.ReadOnly {
    override val intentDiscrepancies: List[
      zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.ReadOnly
    ] = impl
      .intentDiscrepancies()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.wrap(item)
      }
      .toList
    override val slotDiscrepancies
        : List[zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.ReadOnly] =
      impl
        .slotDiscrepancies()
        .asScala
        .map { item =>
          zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyErrors
  ): zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.ReadOnly = new Wrapper(
    impl
  )
}
