package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConversationLogSettings(
    textLogSettings: Optional[
      Iterable[zio.aws.lexmodelsv2.model.TextLogSetting]
    ] = Optional.Absent,
    audioLogSettings: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AudioLogSetting]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogSettings = {
    import ConversationLogSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogSettings
      .builder()
      .optionallyWith(
        textLogSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textLogSettings)
      .optionallyWith(
        audioLogSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.audioLogSettings)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly =
    zio.aws.lexmodelsv2.model.ConversationLogSettings.wrap(buildAwsValue())
}
object ConversationLogSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ConversationLogSettings =
      zio.aws.lexmodelsv2.model.ConversationLogSettings(
        textLogSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        audioLogSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def textLogSettings
        : Optional[List[zio.aws.lexmodelsv2.model.TextLogSetting.ReadOnly]]
    def audioLogSettings
        : Optional[List[zio.aws.lexmodelsv2.model.AudioLogSetting.ReadOnly]]
    def getTextLogSettings: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.TextLogSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("textLogSettings", textLogSettings)
    def getAudioLogSettings: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AudioLogSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("audioLogSettings", audioLogSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogSettings
  ) extends zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly {
    override val textLogSettings
        : Optional[List[zio.aws.lexmodelsv2.model.TextLogSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textLogSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.TextLogSetting.wrap(item)
          }.toList
        )
    override val audioLogSettings
        : Optional[List[zio.aws.lexmodelsv2.model.AudioLogSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioLogSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.AudioLogSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogSettings
  ): zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly = new Wrapper(
    impl
  )
}
