package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait TestResultTypeFilter {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter
}
object TestResultTypeFilter {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter
  ): zio.aws.lexmodelsv2.model.TestResultTypeFilter = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.OVERALL_TEST_RESULTS =>
      val r = OverallTestResults
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.CONVERSATION_LEVEL_TEST_RESULTS =>
      val r = ConversationLevelTestResults
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.INTENT_CLASSIFICATION_TEST_RESULTS =>
      val r = IntentClassificationTestResults
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.SLOT_RESOLUTION_TEST_RESULTS =>
      val r = SlotResolutionTestResults
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.UTTERANCE_LEVEL_RESULTS =>
      val r = UtteranceLevelResults
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TestResultTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object OverallTestResults
      extends zio.aws.lexmodelsv2.model.TestResultTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.OVERALL_TEST_RESULTS
  }
  case object ConversationLevelTestResults
      extends zio.aws.lexmodelsv2.model.TestResultTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.CONVERSATION_LEVEL_TEST_RESULTS
  }
  case object IntentClassificationTestResults
      extends zio.aws.lexmodelsv2.model.TestResultTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.INTENT_CLASSIFICATION_TEST_RESULTS
  }
  case object SlotResolutionTestResults
      extends zio.aws.lexmodelsv2.model.TestResultTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.SLOT_RESOLUTION_TEST_RESULTS
  }
  case object UtteranceLevelResults
      extends zio.aws.lexmodelsv2.model.TestResultTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultTypeFilter.UTTERANCE_LEVEL_RESULTS
  }
}
