package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{Name, Timestamp, Id}
import scala.jdk.CollectionConverters.*
final case class TestExecutionSummary(
    testExecutionId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    testExecutionStatus: Optional[
      zio.aws.lexmodelsv2.model.TestExecutionStatus
    ] = Optional.Absent,
    testSetId: Optional[Id] = Optional.Absent,
    testSetName: Optional[Name] = Optional.Absent,
    target: Optional[zio.aws.lexmodelsv2.model.TestExecutionTarget] =
      Optional.Absent,
    apiMode: Optional[zio.aws.lexmodelsv2.model.TestExecutionApiMode] =
      Optional.Absent,
    testExecutionModality: Optional[
      zio.aws.lexmodelsv2.model.TestExecutionModality
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSummary = {
    import TestExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSummary
      .builder()
      .optionallyWith(
        testExecutionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testExecutionId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(testExecutionStatus.map(value => value.unwrap))(
        _.testExecutionStatus
      )
      .optionallyWith(
        testSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testSetId)
      .optionallyWith(
        testSetName.map(value => Name.unwrap(value): java.lang.String)
      )(_.testSetName)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(apiMode.map(value => value.unwrap))(_.apiMode)
      .optionallyWith(testExecutionModality.map(value => value.unwrap))(
        _.testExecutionModality
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestExecutionSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.TestExecutionSummary.wrap(buildAwsValue())
}
object TestExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestExecutionSummary =
      zio.aws.lexmodelsv2.model.TestExecutionSummary(
        testExecutionId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        testExecutionStatus.map(value => value),
        testSetId.map(value => value),
        testSetName.map(value => value),
        target.map(value => value.asEditable),
        apiMode.map(value => value),
        testExecutionModality.map(value => value)
      )
    def testExecutionId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def testExecutionStatus
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionStatus]
    def testSetId: Optional[Id]
    def testSetName: Optional[Name]
    def target: Optional[zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly]
    def apiMode: Optional[zio.aws.lexmodelsv2.model.TestExecutionApiMode]
    def testExecutionModality
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionModality]
    def getTestExecutionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testExecutionId", testExecutionId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getTestExecutionStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestExecutionStatus] =
      AwsError.unwrapOptionField("testExecutionStatus", testExecutionStatus)
    def getTestSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testSetId", testSetId)
    def getTestSetName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("testSetName", testSetName)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getApiMode
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestExecutionApiMode] =
      AwsError.unwrapOptionField("apiMode", apiMode)
    def getTestExecutionModality
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestExecutionModality] =
      AwsError.unwrapOptionField("testExecutionModality", testExecutionModality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSummary
  ) extends zio.aws.lexmodelsv2.model.TestExecutionSummary.ReadOnly {
    override val testExecutionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testExecutionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val testExecutionStatus
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testExecutionStatus())
        .map(value => zio.aws.lexmodelsv2.model.TestExecutionStatus.wrap(value))
    override val testSetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val testSetName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val target
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value => zio.aws.lexmodelsv2.model.TestExecutionTarget.wrap(value))
    override val apiMode
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionApiMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiMode())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestExecutionApiMode.wrap(value)
        )
    override val testExecutionModality
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionModality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testExecutionModality())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestExecutionModality.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSummary
  ): zio.aws.lexmodelsv2.model.TestExecutionSummary.ReadOnly = new Wrapper(impl)
}
