package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.Count
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SlotResolutionTestResultItemCounts(
    totalResultCount: Count,
    speechTranscriptionResultCounts: Optional[
      Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    ] = Optional.Absent,
    slotMatchResultCounts: Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItemCounts = {
    import SlotResolutionTestResultItemCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItemCounts
      .builder()
      .totalResultCount(Count.unwrap(totalResultCount): Integer)
      .optionallyWith(
        speechTranscriptionResultCounts.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (Count.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.speechTranscriptionResultCountsWithStrings)
      .slotMatchResultCountsWithStrings(
        slotMatchResultCounts
          .map({ case (key, value) =>
            key.unwrap.toString -> (Count.unwrap(value): Integer)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts
      .wrap(buildAwsValue())
}
object SlotResolutionTestResultItemCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItemCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts =
      zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts(
        totalResultCount,
        speechTranscriptionResultCounts.map(value => value),
        slotMatchResultCounts
      )
    def totalResultCount: Count
    def speechTranscriptionResultCounts
        : Optional[Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]]
    def slotMatchResultCounts
        : Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    def getTotalResultCount: ZIO[Any, Nothing, Count] =
      ZIO.succeed(totalResultCount)
    def getSpeechTranscriptionResultCounts: ZIO[Any, AwsError, Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]] = AwsError.unwrapOptionField(
      "speechTranscriptionResultCounts",
      speechTranscriptionResultCounts
    )
    def getSlotMatchResultCounts: ZIO[Any, Nothing, Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]] = ZIO.succeed(slotMatchResultCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItemCounts
  ) extends zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts.ReadOnly {
    override val totalResultCount: Count =
      zio.aws.lexmodelsv2.model.primitives.Count(impl.totalResultCount())
    override val speechTranscriptionResultCounts: Optional[
      Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.speechTranscriptionResultCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.TestResultMatchStatus
              .wrap(key) -> zio.aws.lexmodelsv2.model.primitives.Count(value)
          })
          .toMap
      )
    override val slotMatchResultCounts
        : Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count] = impl
      .slotMatchResultCounts()
      .asScala
      .map({ case (key, value) =>
        zio.aws.lexmodelsv2.model.TestResultMatchStatus
          .wrap(key) -> zio.aws.lexmodelsv2.model.primitives.Count(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItemCounts
  ): zio.aws.lexmodelsv2.model.SlotResolutionTestResultItemCounts.ReadOnly =
    new Wrapper(impl)
}
