package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTestSetsResponse(
    testSets: Optional[Iterable[zio.aws.lexmodelsv2.model.TestSetSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse = {
    import ListTestSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse
      .builder()
      .optionallyWith(
        testSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testSets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListTestSetsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListTestSetsResponse.wrap(buildAwsValue())
}
object ListTestSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListTestSetsResponse =
      zio.aws.lexmodelsv2.model.ListTestSetsResponse(
        testSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def testSets
        : Optional[List[zio.aws.lexmodelsv2.model.TestSetSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTestSets: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.TestSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("testSets", testSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse
  ) extends zio.aws.lexmodelsv2.model.ListTestSetsResponse.ReadOnly {
    override val testSets
        : Optional[List[zio.aws.lexmodelsv2.model.TestSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.TestSetSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse
  ): zio.aws.lexmodelsv2.model.ListTestSetsResponse.ReadOnly = new Wrapper(impl)
}
