package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{TestResultSlotName, Name}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConversationLevelSlotResolutionResultItem(
    intentName: Name,
    slotName: TestResultSlotName,
    matchResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem = {
    import ConversationLevelSlotResolutionResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem
      .builder()
      .intentName(Name.unwrap(intentName): java.lang.String)
      .slotName(TestResultSlotName.unwrap(slotName): java.lang.String)
      .matchResult(matchResult.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem
      .wrap(buildAwsValue())
}
object ConversationLevelSlotResolutionResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem =
      zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem(
        intentName,
        slotName,
        matchResult
      )
    def intentName: Name
    def slotName: TestResultSlotName
    def matchResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus
    def getIntentName: ZIO[Any, Nothing, Name] = ZIO.succeed(intentName)
    def getSlotName: ZIO[Any, Nothing, TestResultSlotName] =
      ZIO.succeed(slotName)
    def getMatchResult
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      ZIO.succeed(matchResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem
  ) extends zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.ReadOnly {
    override val intentName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.intentName())
    override val slotName: TestResultSlotName =
      zio.aws.lexmodelsv2.model.primitives.TestResultSlotName(impl.slotName())
    override val matchResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus =
      zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(impl.matchResult())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem
  ): zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.ReadOnly =
    new Wrapper(impl)
}
