package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConversationLevelResultDetail(
    endToEndResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus,
    speechTranscriptionResult: Optional[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelResultDetail = {
    import ConversationLevelResultDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelResultDetail
      .builder()
      .endToEndResult(endToEndResult.unwrap)
      .optionallyWith(speechTranscriptionResult.map(value => value.unwrap))(
        _.speechTranscriptionResult
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ConversationLevelResultDetail.ReadOnly =
    zio.aws.lexmodelsv2.model.ConversationLevelResultDetail
      .wrap(buildAwsValue())
}
object ConversationLevelResultDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelResultDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ConversationLevelResultDetail =
      zio.aws.lexmodelsv2.model.ConversationLevelResultDetail(
        endToEndResult,
        speechTranscriptionResult.map(value => value)
      )
    def endToEndResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus
    def speechTranscriptionResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus]
    def getEndToEndResult
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      ZIO.succeed(endToEndResult)
    def getSpeechTranscriptionResult
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      AwsError.unwrapOptionField(
        "speechTranscriptionResult",
        speechTranscriptionResult
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelResultDetail
  ) extends zio.aws.lexmodelsv2.model.ConversationLevelResultDetail.ReadOnly {
    override val endToEndResult
        : zio.aws.lexmodelsv2.model.TestResultMatchStatus =
      zio.aws.lexmodelsv2.model.TestResultMatchStatus
        .wrap(impl.endToEndResult())
    override val speechTranscriptionResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speechTranscriptionResult())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelResultDetail
  ): zio.aws.lexmodelsv2.model.ConversationLevelResultDetail.ReadOnly =
    new Wrapper(impl)
}
