package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsIntentStageResult(
    binKeys: Optional[Iterable[zio.aws.lexmodelsv2.model.AnalyticsBinKey]] =
      Optional.Absent,
    groupByKeys: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentStageGroupByKey]
    ] = Optional.Absent,
    metricsResults: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageResult = {
    import AnalyticsIntentStageResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageResult
      .builder()
      .optionallyWith(
        binKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.binKeys)
      .optionallyWith(
        groupByKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupByKeys)
      .optionallyWith(
        metricsResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricsResults)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.wrap(buildAwsValue())
}
object AnalyticsIntentStageResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult =
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult(
        binKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupByKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricsResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]]
    def groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentStageGroupByKey.ReadOnly]
    ]
    def metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult.ReadOnly]
    ]
    def getBinKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly
    ]] = AwsError.unwrapOptionField("binKeys", binKeys)
    def getGroupByKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageGroupByKey.ReadOnly
    ]] = AwsError.unwrapOptionField("groupByKeys", groupByKeys)
    def getMetricsResults: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricsResults", metricsResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.ReadOnly {
    override val binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.AnalyticsBinKey.wrap(item)
          }.toList
        )
    override val groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentStageGroupByKey.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupByKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentStageGroupByKey.wrap(item)
        }.toList
      )
    override val metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricsResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageResult
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.ReadOnly =
    new Wrapper(impl)
}
