package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  TestSetConversationId,
  RecordNumber
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UtteranceLevelTestResultItem(
    recordNumber: RecordNumber,
    conversationId: Optional[TestSetConversationId] = Optional.Absent,
    turnResult: zio.aws.lexmodelsv2.model.TestSetTurnResult
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceLevelTestResultItem = {
    import UtteranceLevelTestResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceLevelTestResultItem
      .builder()
      .recordNumber(RecordNumber.unwrap(recordNumber): java.lang.Long)
      .optionallyWith(
        conversationId.map(value =>
          TestSetConversationId.unwrap(value): java.lang.String
        )
      )(_.conversationId)
      .turnResult(turnResult.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UtteranceLevelTestResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.UtteranceLevelTestResultItem.wrap(buildAwsValue())
}
object UtteranceLevelTestResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceLevelTestResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UtteranceLevelTestResultItem =
      zio.aws.lexmodelsv2.model.UtteranceLevelTestResultItem(
        recordNumber,
        conversationId.map(value => value),
        turnResult.asEditable
      )
    def recordNumber: RecordNumber
    def conversationId: Optional[TestSetConversationId]
    def turnResult: zio.aws.lexmodelsv2.model.TestSetTurnResult.ReadOnly
    def getRecordNumber: ZIO[Any, Nothing, RecordNumber] =
      ZIO.succeed(recordNumber)
    def getConversationId: ZIO[Any, AwsError, TestSetConversationId] =
      AwsError.unwrapOptionField("conversationId", conversationId)
    def getTurnResult: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestSetTurnResult.ReadOnly
    ] = ZIO.succeed(turnResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceLevelTestResultItem
  ) extends zio.aws.lexmodelsv2.model.UtteranceLevelTestResultItem.ReadOnly {
    override val recordNumber: RecordNumber =
      zio.aws.lexmodelsv2.model.primitives.RecordNumber(impl.recordNumber())
    override val conversationId: Optional[TestSetConversationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationId())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.TestSetConversationId(value)
        )
    override val turnResult
        : zio.aws.lexmodelsv2.model.TestSetTurnResult.ReadOnly =
      zio.aws.lexmodelsv2.model.TestSetTurnResult.wrap(impl.turnResult())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceLevelTestResultItem
  ): zio.aws.lexmodelsv2.model.UtteranceLevelTestResultItem.ReadOnly =
    new Wrapper(impl)
}
