package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTestSetRecordsResponse(
    testSetRecords: Optional[
      Iterable[zio.aws.lexmodelsv2.model.TestSetTurnRecord]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse = {
    import ListTestSetRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse
      .builder()
      .optionallyWith(
        testSetRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testSetRecords)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListTestSetRecordsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListTestSetRecordsResponse.wrap(buildAwsValue())
}
object ListTestSetRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListTestSetRecordsResponse =
      zio.aws.lexmodelsv2.model.ListTestSetRecordsResponse(
        testSetRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def testSetRecords
        : Optional[List[zio.aws.lexmodelsv2.model.TestSetTurnRecord.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTestSetRecords: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.TestSetTurnRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("testSetRecords", testSetRecords)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse
  ) extends zio.aws.lexmodelsv2.model.ListTestSetRecordsResponse.ReadOnly {
    override val testSetRecords
        : Optional[List[zio.aws.lexmodelsv2.model.TestSetTurnRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.TestSetTurnRecord.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse
  ): zio.aws.lexmodelsv2.model.ListTestSetRecordsResponse.ReadOnly =
    new Wrapper(impl)
}
