package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{NextToken, MaxResults, Id}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTestExecutionResultItemsRequest(
    testExecutionId: Id,
    resultFilterBy: zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest = {
    import ListTestExecutionResultItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest
      .builder()
      .testExecutionId(Id.unwrap(testExecutionId): java.lang.String)
      .resultFilterBy(resultFilterBy.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsRequest
      .wrap(buildAwsValue())
}
object ListTestExecutionResultItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsRequest =
      zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsRequest(
        testExecutionId,
        resultFilterBy.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def testExecutionId: Id
    def resultFilterBy
        : zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy.ReadOnly
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getTestExecutionId: ZIO[Any, Nothing, Id] = ZIO.succeed(testExecutionId)
    def getResultFilterBy: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy.ReadOnly
    ] = ZIO.succeed(resultFilterBy)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest
  ) extends zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsRequest.ReadOnly {
    override val testExecutionId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testExecutionId())
    override val resultFilterBy
        : zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy.ReadOnly =
      zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy
        .wrap(impl.resultFilterBy())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest
  ): zio.aws.lexmodelsv2.model.ListTestExecutionResultItemsRequest.ReadOnly =
    new Wrapper(impl)
}
