package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  TurnNumber,
  TestSetConversationId,
  RecordNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TestSetTurnRecord(
    recordNumber: RecordNumber,
    conversationId: Optional[TestSetConversationId] = Optional.Absent,
    turnNumber: Optional[TurnNumber] = Optional.Absent,
    turnSpecification: zio.aws.lexmodelsv2.model.TurnSpecification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord = {
    import TestSetTurnRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord
      .builder()
      .recordNumber(RecordNumber.unwrap(recordNumber): java.lang.Long)
      .optionallyWith(
        conversationId.map(value =>
          TestSetConversationId.unwrap(value): java.lang.String
        )
      )(_.conversationId)
      .optionallyWith(
        turnNumber.map(value => TurnNumber.unwrap(value): Integer)
      )(_.turnNumber)
      .turnSpecification(turnSpecification.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestSetTurnRecord.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetTurnRecord.wrap(buildAwsValue())
}
object TestSetTurnRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetTurnRecord =
      zio.aws.lexmodelsv2.model.TestSetTurnRecord(
        recordNumber,
        conversationId.map(value => value),
        turnNumber.map(value => value),
        turnSpecification.asEditable
      )
    def recordNumber: RecordNumber
    def conversationId: Optional[TestSetConversationId]
    def turnNumber: Optional[TurnNumber]
    def turnSpecification: zio.aws.lexmodelsv2.model.TurnSpecification.ReadOnly
    def getRecordNumber: ZIO[Any, Nothing, RecordNumber] =
      ZIO.succeed(recordNumber)
    def getConversationId: ZIO[Any, AwsError, TestSetConversationId] =
      AwsError.unwrapOptionField("conversationId", conversationId)
    def getTurnNumber: ZIO[Any, AwsError, TurnNumber] =
      AwsError.unwrapOptionField("turnNumber", turnNumber)
    def getTurnSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TurnSpecification.ReadOnly
    ] = ZIO.succeed(turnSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord
  ) extends zio.aws.lexmodelsv2.model.TestSetTurnRecord.ReadOnly {
    override val recordNumber: RecordNumber =
      zio.aws.lexmodelsv2.model.primitives.RecordNumber(impl.recordNumber())
    override val conversationId: Optional[TestSetConversationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationId())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.TestSetConversationId(value)
        )
    override val turnNumber: Optional[TurnNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.turnNumber())
      .map(value => zio.aws.lexmodelsv2.model.primitives.TurnNumber(value))
    override val turnSpecification
        : zio.aws.lexmodelsv2.model.TurnSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.TurnSpecification.wrap(impl.turnSpecification())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord
  ): zio.aws.lexmodelsv2.model.TestSetTurnRecord.ReadOnly = new Wrapper(impl)
}
