package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{BuiltInOrCustomSlotTypeId, Name}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SubSlotTypeComposition(
    name: Name,
    slotTypeId: BuiltInOrCustomSlotTypeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition = {
    import SubSlotTypeComposition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .slotTypeId(
        BuiltInOrCustomSlotTypeId.unwrap(slotTypeId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SubSlotTypeComposition.ReadOnly =
    zio.aws.lexmodelsv2.model.SubSlotTypeComposition.wrap(buildAwsValue())
}
object SubSlotTypeComposition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SubSlotTypeComposition =
      zio.aws.lexmodelsv2.model.SubSlotTypeComposition(name, slotTypeId)
    def name: Name
    def slotTypeId: BuiltInOrCustomSlotTypeId
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSlotTypeId: ZIO[Any, Nothing, BuiltInOrCustomSlotTypeId] =
      ZIO.succeed(slotTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition
  ) extends zio.aws.lexmodelsv2.model.SubSlotTypeComposition.ReadOnly {
    override val name: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.name())
    override val slotTypeId: BuiltInOrCustomSlotTypeId =
      zio.aws.lexmodelsv2.model.primitives
        .BuiltInOrCustomSlotTypeId(impl.slotTypeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition
  ): zio.aws.lexmodelsv2.model.SubSlotTypeComposition.ReadOnly = new Wrapper(
    impl
  )
}
