package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  LocaleId,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCustomVocabularyItemsResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    customVocabularyItems: Optional[
      Iterable[zio.aws.lexmodelsv2.model.CustomVocabularyItem]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse = {
    import ListCustomVocabularyItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        customVocabularyItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customVocabularyItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse
      .wrap(buildAwsValue())
}
object ListCustomVocabularyItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse =
      zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        customVocabularyItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def localeId: Optional[LocaleId]
    def customVocabularyItems: Optional[
      List[zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getCustomVocabularyItems: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customVocabularyItems", customVocabularyItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse
  ) extends zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val customVocabularyItems: Optional[
      List[zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customVocabularyItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.CustomVocabularyItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse
  ): zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse.ReadOnly =
    new Wrapper(impl)
}
