package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BotSortBy(
    attribute: zio.aws.lexmodelsv2.model.BotSortAttribute,
    order: zio.aws.lexmodelsv2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotSortBy = {
    import BotSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotSortBy
      .builder()
      .attribute(attribute.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.BotSortBy.wrap(buildAwsValue())
}
object BotSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotSortBy =
      zio.aws.lexmodelsv2.model.BotSortBy(attribute, order)
    def attribute: zio.aws.lexmodelsv2.model.BotSortAttribute
    def order: zio.aws.lexmodelsv2.model.SortOrder
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.BotSortAttribute] =
      ZIO.succeed(attribute)
    def getOrder: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotSortBy
  ) extends zio.aws.lexmodelsv2.model.BotSortBy.ReadOnly {
    override val attribute: zio.aws.lexmodelsv2.model.BotSortAttribute =
      zio.aws.lexmodelsv2.model.BotSortAttribute.wrap(impl.attribute())
    override val order: zio.aws.lexmodelsv2.model.SortOrder =
      zio.aws.lexmodelsv2.model.SortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotSortBy
  ): zio.aws.lexmodelsv2.model.BotSortBy.ReadOnly = new Wrapper(impl)
}
