package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  SkipResourceInUseCheck,
  Id,
  BotAliasId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteBotAliasRequest(
    botAliasId: BotAliasId,
    botId: Id,
    skipResourceInUseCheck: Optional[SkipResourceInUseCheck] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest = {
    import DeleteBotAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest
      .builder()
      .botAliasId(BotAliasId.unwrap(botAliasId): java.lang.String)
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(
        skipResourceInUseCheck.map(value =>
          SkipResourceInUseCheck.unwrap(value): java.lang.Boolean
        )
      )(_.skipResourceInUseCheck)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotAliasRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotAliasRequest.wrap(buildAwsValue())
}
object DeleteBotAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotAliasRequest =
      zio.aws.lexmodelsv2.model.DeleteBotAliasRequest(
        botAliasId,
        botId,
        skipResourceInUseCheck.map(value => value)
      )
    def botAliasId: BotAliasId
    def botId: Id
    def skipResourceInUseCheck: Optional[SkipResourceInUseCheck]
    def getBotAliasId: ZIO[Any, Nothing, BotAliasId] = ZIO.succeed(botAliasId)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getSkipResourceInUseCheck: ZIO[Any, AwsError, SkipResourceInUseCheck] =
      AwsError.unwrapOptionField(
        "skipResourceInUseCheck",
        skipResourceInUseCheck
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteBotAliasRequest.ReadOnly {
    override val botAliasId: BotAliasId =
      zio.aws.lexmodelsv2.model.primitives.BotAliasId(impl.botAliasId())
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val skipResourceInUseCheck: Optional[SkipResourceInUseCheck] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipResourceInUseCheck())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.SkipResourceInUseCheck(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest
  ): zio.aws.lexmodelsv2.model.DeleteBotAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
