package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DialogState(
    dialogAction: Optional[zio.aws.lexmodelsv2.model.DialogAction] =
      Optional.Absent,
    intent: Optional[zio.aws.lexmodelsv2.model.IntentOverride] =
      Optional.Absent,
    sessionAttributes: Optional[Map[NonEmptyString, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DialogState = {
    import DialogState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DialogState
      .builder()
      .optionallyWith(dialogAction.map(value => value.buildAwsValue()))(
        _.dialogAction
      )
      .optionallyWith(intent.map(value => value.buildAwsValue()))(_.intent)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DialogState.ReadOnly =
    zio.aws.lexmodelsv2.model.DialogState.wrap(buildAwsValue())
}
object DialogState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DialogState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DialogState =
      zio.aws.lexmodelsv2.model.DialogState(
        dialogAction.map(value => value.asEditable),
        intent.map(value => value.asEditable),
        sessionAttributes.map(value => value)
      )
    def dialogAction: Optional[zio.aws.lexmodelsv2.model.DialogAction.ReadOnly]
    def intent: Optional[zio.aws.lexmodelsv2.model.IntentOverride.ReadOnly]
    def sessionAttributes: Optional[Map[NonEmptyString, String]]
    def getDialogAction
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogAction.ReadOnly] =
      AwsError.unwrapOptionField("dialogAction", dialogAction)
    def getIntent: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentOverride.ReadOnly
    ] = AwsError.unwrapOptionField("intent", intent)
    def getSessionAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DialogState
  ) extends zio.aws.lexmodelsv2.model.DialogState.ReadOnly {
    override val dialogAction
        : Optional[zio.aws.lexmodelsv2.model.DialogAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dialogAction())
        .map(value => zio.aws.lexmodelsv2.model.DialogAction.wrap(value))
    override val intent
        : Optional[zio.aws.lexmodelsv2.model.IntentOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intent())
        .map(value => zio.aws.lexmodelsv2.model.IntentOverride.wrap(value))
    override val sessionAttributes: Optional[Map[NonEmptyString, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexmodelsv2.model.primitives
                .NonEmptyString(key) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DialogState
  ): zio.aws.lexmodelsv2.model.DialogState.ReadOnly = new Wrapper(impl)
}
