package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.TimeInMilliSeconds
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AudioAndDTMFInputSpecification(
    startTimeoutMs: TimeInMilliSeconds,
    audioSpecification: Optional[zio.aws.lexmodelsv2.model.AudioSpecification] =
      Optional.Absent,
    dtmfSpecification: Optional[zio.aws.lexmodelsv2.model.DTMFSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AudioAndDTMFInputSpecification = {
    import AudioAndDTMFInputSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AudioAndDTMFInputSpecification
      .builder()
      .startTimeoutMs(TimeInMilliSeconds.unwrap(startTimeoutMs): Integer)
      .optionallyWith(audioSpecification.map(value => value.buildAwsValue()))(
        _.audioSpecification
      )
      .optionallyWith(dtmfSpecification.map(value => value.buildAwsValue()))(
        _.dtmfSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification
      .wrap(buildAwsValue())
}
object AudioAndDTMFInputSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AudioAndDTMFInputSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification =
      zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification(
        startTimeoutMs,
        audioSpecification.map(value => value.asEditable),
        dtmfSpecification.map(value => value.asEditable)
      )
    def startTimeoutMs: TimeInMilliSeconds
    def audioSpecification
        : Optional[zio.aws.lexmodelsv2.model.AudioSpecification.ReadOnly]
    def dtmfSpecification
        : Optional[zio.aws.lexmodelsv2.model.DTMFSpecification.ReadOnly]
    def getStartTimeoutMs: ZIO[Any, Nothing, TimeInMilliSeconds] =
      ZIO.succeed(startTimeoutMs)
    def getAudioSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AudioSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("audioSpecification", audioSpecification)
    def getDtmfSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.DTMFSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("dtmfSpecification", dtmfSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioAndDTMFInputSpecification
  ) extends zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification.ReadOnly {
    override val startTimeoutMs: TimeInMilliSeconds =
      zio.aws.lexmodelsv2.model.primitives
        .TimeInMilliSeconds(impl.startTimeoutMs())
    override val audioSpecification
        : Optional[zio.aws.lexmodelsv2.model.AudioSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioSpecification())
        .map(value => zio.aws.lexmodelsv2.model.AudioSpecification.wrap(value))
    override val dtmfSpecification
        : Optional[zio.aws.lexmodelsv2.model.DTMFSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dtmfSpecification())
        .map(value => zio.aws.lexmodelsv2.model.DTMFSpecification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioAndDTMFInputSpecification
  ): zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification.ReadOnly =
    new Wrapper(impl)
}
