package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomVocabularyImportSpecification(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyImportSpecification = {
    import CustomVocabularyImportSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyImportSpecification
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification
      .wrap(buildAwsValue())
}
object CustomVocabularyImportSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyImportSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification =
      zio.aws.lexmodelsv2.model
        .CustomVocabularyImportSpecification(botId, botVersion, localeId)
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyImportSpecification
  ) extends zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyImportSpecification
  ): zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification.ReadOnly =
    new Wrapper(impl)
}
