package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait MessageSelectionStrategy {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy
}
object MessageSelectionStrategy {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy
  ): zio.aws.lexmodelsv2.model.MessageSelectionStrategy = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy.RANDOM =>
      val r = Random
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy.ORDERED =>
      val r = Ordered
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.MessageSelectionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object Random
      extends zio.aws.lexmodelsv2.model.MessageSelectionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy.RANDOM
  }
  case object Ordered
      extends zio.aws.lexmodelsv2.model.MessageSelectionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.MessageSelectionStrategy.ORDERED
  }
}
