package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  Timestamp,
  FailureReason,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class DescribeTestSetGenerationResponse(
    testSetGenerationId: Optional[Id] = Optional.Absent,
    testSetGenerationStatus: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationStatus
    ] = Optional.Absent,
    failureReasons: Optional[Iterable[FailureReason]] = Optional.Absent,
    testSetId: Optional[Id] = Optional.Absent,
    testSetName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    storageLocation: Optional[
      zio.aws.lexmodelsv2.model.TestSetStorageLocation
    ] = Optional.Absent,
    generationDataSource: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource
    ] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse = {
    import DescribeTestSetGenerationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse
      .builder()
      .optionallyWith(
        testSetGenerationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testSetGenerationId)
      .optionallyWith(testSetGenerationStatus.map(value => value.unwrap))(
        _.testSetGenerationStatus
      )
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .optionallyWith(
        testSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testSetId)
      .optionallyWith(
        testSetName.map(value => Name.unwrap(value): java.lang.String)
      )(_.testSetName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .optionallyWith(generationDataSource.map(value => value.buildAwsValue()))(
        _.generationDataSource
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeTestSetGenerationResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeTestSetGenerationResponse
      .wrap(buildAwsValue())
}
object DescribeTestSetGenerationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.DescribeTestSetGenerationResponse =
      zio.aws.lexmodelsv2.model.DescribeTestSetGenerationResponse(
        testSetGenerationId.map(value => value),
        testSetGenerationStatus.map(value => value),
        failureReasons.map(value => value),
        testSetId.map(value => value),
        testSetName.map(value => value),
        description.map(value => value),
        storageLocation.map(value => value.asEditable),
        generationDataSource.map(value => value.asEditable),
        roleArn.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def testSetGenerationId: Optional[Id]
    def testSetGenerationStatus
        : Optional[zio.aws.lexmodelsv2.model.TestSetGenerationStatus]
    def failureReasons: Optional[List[FailureReason]]
    def testSetId: Optional[Id]
    def testSetName: Optional[Name]
    def description: Optional[Description]
    def storageLocation
        : Optional[zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly]
    def generationDataSource: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    ]
    def roleArn: Optional[RoleArn]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def getTestSetGenerationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testSetGenerationId", testSetGenerationId)
    def getTestSetGenerationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetGenerationStatus
    ] = AwsError.unwrapOptionField(
      "testSetGenerationStatus",
      testSetGenerationStatus
    )
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
    def getTestSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testSetId", testSetId)
    def getTestSetName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("testSetName", testSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStorageLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly
    ] = AwsError.unwrapOptionField("storageLocation", storageLocation)
    def getGenerationDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    ] = AwsError.unwrapOptionField("generationDataSource", generationDataSource)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeTestSetGenerationResponse.ReadOnly {
    override val testSetGenerationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetGenerationId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val testSetGenerationStatus
        : Optional[zio.aws.lexmodelsv2.model.TestSetGenerationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetGenerationStatus())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestSetGenerationStatus.wrap(value)
        )
    override val failureReasons: Optional[List[FailureReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
          }.toList
        )
    override val testSetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val testSetName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val storageLocation
        : Optional[zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageLocation())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestSetStorageLocation.wrap(value)
        )
    override val generationDataSource: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.generationDataSource())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.wrap(value)
      )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RoleArn(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse
  ): zio.aws.lexmodelsv2.model.DescribeTestSetGenerationResponse.ReadOnly =
    new Wrapper(impl)
}
