package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{PresignedS3Url, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUploadUrlResponse(
    importId: Optional[Id] = Optional.Absent,
    uploadUrl: Optional[PresignedS3Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse = {
    import CreateUploadUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(
        uploadUrl.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.uploadUrl)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.wrap(buildAwsValue())
}
object CreateUploadUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateUploadUrlResponse =
      zio.aws.lexmodelsv2.model.CreateUploadUrlResponse(
        importId.map(value => value),
        uploadUrl.map(value => value)
      )
    def importId: Optional[Id]
    def uploadUrl: Optional[PresignedS3Url]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getUploadUrl: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("uploadUrl", uploadUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
  ) extends zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly {
    override val importId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val uploadUrl: Optional[PresignedS3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadUrl())
      .map(value => zio.aws.lexmodelsv2.model.primitives.PresignedS3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
  ): zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
