package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  AnalyticsNodeLevel,
  AnalyticsNodeCount,
  AnalyticsPath,
  Name
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AnalyticsIntentNodeSummary(
    intentName: Optional[Name] = Optional.Absent,
    intentPath: Optional[AnalyticsPath] = Optional.Absent,
    intentCount: Optional[AnalyticsNodeCount] = Optional.Absent,
    intentLevel: Optional[AnalyticsNodeLevel] = Optional.Absent,
    nodeType: Optional[zio.aws.lexmodelsv2.model.AnalyticsNodeType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary = {
    import AnalyticsIntentNodeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary
      .builder()
      .optionallyWith(
        intentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        intentPath.map(value => AnalyticsPath.unwrap(value): java.lang.String)
      )(_.intentPath)
      .optionallyWith(
        intentCount.map(value => AnalyticsNodeCount.unwrap(value): Integer)
      )(_.intentCount)
      .optionallyWith(
        intentLevel.map(value => AnalyticsNodeLevel.unwrap(value): Integer)
      )(_.intentLevel)
      .optionallyWith(nodeType.map(value => value.unwrap))(_.nodeType)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.wrap(buildAwsValue())
}
object AnalyticsIntentNodeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary =
      zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary(
        intentName.map(value => value),
        intentPath.map(value => value),
        intentCount.map(value => value),
        intentLevel.map(value => value),
        nodeType.map(value => value)
      )
    def intentName: Optional[Name]
    def intentPath: Optional[AnalyticsPath]
    def intentCount: Optional[AnalyticsNodeCount]
    def intentLevel: Optional[AnalyticsNodeLevel]
    def nodeType: Optional[zio.aws.lexmodelsv2.model.AnalyticsNodeType]
    def getIntentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getIntentPath: ZIO[Any, AwsError, AnalyticsPath] =
      AwsError.unwrapOptionField("intentPath", intentPath)
    def getIntentCount: ZIO[Any, AwsError, AnalyticsNodeCount] =
      AwsError.unwrapOptionField("intentCount", intentCount)
    def getIntentLevel: ZIO[Any, AwsError, AnalyticsNodeLevel] =
      AwsError.unwrapOptionField("intentLevel", intentLevel)
    def getNodeType
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsNodeType] =
      AwsError.unwrapOptionField("nodeType", nodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.ReadOnly {
    override val intentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val intentPath: Optional[AnalyticsPath] = zio.aws.core.internal
      .optionalFromNullable(impl.intentPath())
      .map(value => zio.aws.lexmodelsv2.model.primitives.AnalyticsPath(value))
    override val intentCount: Optional[AnalyticsNodeCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intentCount())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.AnalyticsNodeCount(value)
        )
    override val intentLevel: Optional[AnalyticsNodeLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intentLevel())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.AnalyticsNodeLevel(value)
        )
    override val nodeType
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsNodeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeType())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsNodeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentNodeSummary
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.ReadOnly =
    new Wrapper(impl)
}
