package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait AnalyticsBinByName {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName
}
object AnalyticsBinByName {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName
  ): zio.aws.lexmodelsv2.model.AnalyticsBinByName = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName.CONVERSATION_START_TIME =>
      val r = ConversationStartTime
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName.UTTERANCE_TIMESTAMP =>
      val r = UtteranceTimestamp
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.AnalyticsBinByName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName.UNKNOWN_TO_SDK_VERSION
  }
  case object ConversationStartTime
      extends zio.aws.lexmodelsv2.model.AnalyticsBinByName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName.CONVERSATION_START_TIME
  }
  case object UtteranceTimestamp
      extends zio.aws.lexmodelsv2.model.AnalyticsBinByName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByName.UTTERANCE_TIMESTAMP
  }
}
