package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UtteranceDataSortBy(
    name: zio.aws.lexmodelsv2.model.AnalyticsUtteranceSortByName,
    order: zio.aws.lexmodelsv2.model.AnalyticsSortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceDataSortBy = {
    import UtteranceDataSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceDataSortBy
      .builder()
      .name(name.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UtteranceDataSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.UtteranceDataSortBy.wrap(buildAwsValue())
}
object UtteranceDataSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceDataSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UtteranceDataSortBy =
      zio.aws.lexmodelsv2.model.UtteranceDataSortBy(name, order)
    def name: zio.aws.lexmodelsv2.model.AnalyticsUtteranceSortByName
    def order: zio.aws.lexmodelsv2.model.AnalyticsSortOrder
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceSortByName
    ] = ZIO.succeed(name)
    def getOrder
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceDataSortBy
  ) extends zio.aws.lexmodelsv2.model.UtteranceDataSortBy.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.AnalyticsUtteranceSortByName =
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceSortByName.wrap(impl.name())
    override val order: zio.aws.lexmodelsv2.model.AnalyticsSortOrder =
      zio.aws.lexmodelsv2.model.AnalyticsSortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceDataSortBy
  ): zio.aws.lexmodelsv2.model.UtteranceDataSortBy.ReadOnly = new Wrapper(impl)
}
