package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportResourceSpecification(
    botExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotExportSpecification
    ] = Optional.Absent,
    botLocaleExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification
    ] = Optional.Absent,
    customVocabularyExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyExportSpecification
    ] = Optional.Absent,
    testSetExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.TestSetExportSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification = {
    import ExportResourceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
      .builder()
      .optionallyWith(
        botExportSpecification.map(value => value.buildAwsValue())
      )(_.botExportSpecification)
      .optionallyWith(
        botLocaleExportSpecification.map(value => value.buildAwsValue())
      )(_.botLocaleExportSpecification)
      .optionallyWith(
        customVocabularyExportSpecification.map(value => value.buildAwsValue())
      )(_.customVocabularyExportSpecification)
      .optionallyWith(
        testSetExportSpecification.map(value => value.buildAwsValue())
      )(_.testSetExportSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.ExportResourceSpecification.wrap(buildAwsValue())
}
object ExportResourceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ExportResourceSpecification =
      zio.aws.lexmodelsv2.model.ExportResourceSpecification(
        botExportSpecification.map(value => value.asEditable),
        botLocaleExportSpecification.map(value => value.asEditable),
        customVocabularyExportSpecification.map(value => value.asEditable),
        testSetExportSpecification.map(value => value.asEditable)
      )
    def botExportSpecification
        : Optional[zio.aws.lexmodelsv2.model.BotExportSpecification.ReadOnly]
    def botLocaleExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly
    ]
    def customVocabularyExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyExportSpecification.ReadOnly
    ]
    def testSetExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.TestSetExportSpecification.ReadOnly
    ]
    def getBotExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botExportSpecification",
      botExportSpecification
    )
    def getBotLocaleExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botLocaleExportSpecification",
      botLocaleExportSpecification
    )
    def getCustomVocabularyExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.CustomVocabularyExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customVocabularyExportSpecification",
      customVocabularyExportSpecification
    )
    def getTestSetExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "testSetExportSpecification",
      testSetExportSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
  ) extends zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly {
    override val botExportSpecification
        : Optional[zio.aws.lexmodelsv2.model.BotExportSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botExportSpecification())
        .map(value =>
          zio.aws.lexmodelsv2.model.BotExportSpecification.wrap(value)
        )
    override val botLocaleExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botLocaleExportSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.wrap(value)
      )
    override val customVocabularyExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyExportSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customVocabularyExportSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.CustomVocabularyExportSpecification
          .wrap(value)
      )
    override val testSetExportSpecification: Optional[
      zio.aws.lexmodelsv2.model.TestSetExportSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetExportSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetExportSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
  ): zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly =
    new Wrapper(impl)
}
